% irfvar to single shock
% credit to
% irfvar.m
% Lutz Kilian
% University of Michigan
% April 1997

function [IRF]=irfvar_single(A,SIGMA,p)

global h q posR

e_shock = zeros(q, 1);
e_shock(posR) = 1;

J=[eye(q,q) zeros(q,q*(p-1))];
decomp = chol(SIGMA);
decomp = decomp(1:q, 1:q);
IRF=J*A^0*J'*decomp'*e_shock;

for i=1:h
	IRF=[IRF J*A^i*J'*decomp'*e_shock];
end;
